<?php
/*
Plugin Name: XE Preview V3.1
Description: [xe-preview key="{API-Key}"]
*/
define( 'XEP_PLUGIN', __FILE__ );
define( 'XEP_PLUGIN_DIR', untrailingslashit( dirname( XEP_PLUGIN ) ) );
define( 'XEP_PLUGIN_VIEWS_DIR', XEP_PLUGIN_DIR . '/views/' );

function render($attributes){
    $out = "";
    $api_key = isset($attributes["key"]) ? $attributes["key"] : '0';
    $domain = isset($attributes["domain"]) ? $attributes["domain"] : 'https://xeev.app';
    $cat_id = isset($_GET['catid']) ? $_GET['catid'] : '0';

    $version_string = "_v3";

    if (isset($attributes["v2"]) && ($attributes["v2"] == '1') ){
        $version_string = "";
    }

    $api_url = "$domain/en/tmpl_api$version_string?key=$api_key&catid=$cat_id";

    $response = wp_remote_get($api_url, array( 'timeout' => 10, 'user-agent' => 'XEEV-PREVIEW'));

    if ( is_array( $response ) && ! is_wp_error( $response ) ) {
        $body    = $response['body'];
        $data = json_decode($body);
        if (property_exists($data,"data")){
            ob_start();
            include(XEP_PLUGIN_VIEWS_DIR."list.php");
            $out = ob_get_contents();
            ob_end_clean();
        }
    }

    return $out;

}

add_action('init', 'init_page');
function init_page() {
    wp_register_style( 'xe_style', plugins_url('/css/style.css', __FILE__), false, '1.0.0', 'all');
}
add_action('wp_enqueue_scripts', 'enqueue_style');
function enqueue_style(){
    wp_enqueue_style( 'xe_style' );
}
add_shortcode( 'xe-preview', 'render' );
